
; Compile with Hi-Tech PICC Lite.
; External C function coded in assmbler and linked against the other C files that comprise the project.
; Demonstrates how we may easily reuse assembler code taken from kbd151.asm virtually unchanged.
; See original article, "PIC to PS/2 Mouse and Keyboard Interfacing" (EPE Aug 04) for more details.

; This file will be assembled by the Hi-Tech C assembler

; In main.c, we declare an external function, receive, that returns a structure containing two 8-bit values,
; (the scan codes):
; extern struct scancodes receive(void);

	processor 16f627 

	Z 		equ 2
	PORTA 	equ 5
	STATUS 	equ 3
	
	; SIGNAT used for link time signature checking of external functions. The number was produced by
	; creating a 'dummy' C file with the same prototype and compiling to assembler code with the -S option
	; from the command line. I used:  picl -16F627 -S dummy.c
	; You can then examine the output assembler file to see the correct value of SIGNAT for your function.
	; You only need to do this if you are writing assembly language routines that are called from C using
	; an extern declaration in this way. See the Hi-Tech PICC Lite manual for further detail.

	PSECT text0,class=CODE,local,delta=2
	GLOBAL _receive
	SIGNAT _receive,90

	; Same name as the C function, with an underscore prefix
	
	_receive

	; In the original code, variables used are EQUated to a particualar memory location in bank 0. ???
	; We have to do this slightly differently, because this is not absolute code. We have no idea how
	; the linker will position the code, or what exists already in bank 0. So we'll just reserve some
	; memory for the variables we need and let the linker figure it out.

	PSECT rbss_0,class=BANK0,space=1
	BYTE ds 1
	BYTE2 ds 1
	LOOP ds 1
	PAR ds 1
	PAR2 ds 1

	PSECT text0

	; JB's code - taken from kbd151.asm and shown as Listing 1 in the original article.
	; Original comments retained.

MAIN:
	comf PORTA,W
	andlw %00000011
	btfsc STATUS,Z
	goto MAIN

	call RECEIVE      ; get keyboard key pressed

	movf BYTE,W       ; is BYTE > 0
	btfsc STATUS,Z
	goto MAIN         ; no, so try again

	btfss PAR,0       ; yes, is parity bit correct (hi)?
	goto MAIN         ; no, so start again
	btfss PAR2,0      ; yes, so is 2nd parity bit correct (hi)?
	goto MAIN         ; no, so start again

	movf BYTE,W      ; is BYTE = $AA (keyboard OK response on power up)?
	xorlw $AA
	btfss STATUS,2
	goto MAINA
	goto MAIN

MAINA:
	movf BYTE2,W      ; is BYTE2 = $E1 (pause/break)?
	xorlw $E1
	btfss STATUS,Z
	goto MAINB
	goto MAIN

MAINB:
	movf BYTE2,W      ; is BYTE2 = $E0?
	xorlw $E0
	btfsc STATUS,2    ; no
	goto MAIN         ; yes - ignore


	; return the scan codes in memory, since our struct is less than 4 bytes in size.
	; to do this, use the temp PSECT (for temporary data). btemp is the label at the
	; start of this PSECT. See the PICC Lite manual for further detail.

	PSECT temp,class=BANK0,space=1
	btemp ds 2
	PSECT text0

	movf BYTE, W
	movwf btemp
	movf BYTE2, W
	movwf btemp+1
	return

	; JB's code - taken unchanged from kbd151.asm. Original comments retained.

RECEIVE:
	clrf BYTE
	clrf BYTE2
	movlw 8           ; number of bits
	movwf LOOP
	clrf PAR          ; clear parity record for BYTE
	movlw 1           ; but set parity record for BYTE2
	movwf PAR2

RX1:
	btfss PORTA,1     ; wait till clock high (idle clock)
	goto RX1
	btfsc PORTA,0     ; is data line low (start bit low)?
	return            ; no it's high, so a false Start bit, restart

RECDATA:
	rrf BYTE,F        ; rotate byte right
	call HIGHLOW      ; wait for clk hi to lo transition

RX2:
	btfsc PORTA,0     ; is data low? 
	goto RECSET       ; no, it's high
	bcf BYTE,7        ; yes, data is low so clear bit 7 of BYTE
	goto RECNEXT      ; and ignore parity counter
      
RECSET:
	bsf BYTE,7        ; set bit 7 of BYTE
	incf PAR,F        ; inc parity counter

RECNEXT:
	decfsz LOOP,F
	goto RECDATA      ; loop until 8 bits have been recd
	call HIGHLOW      ; wait for clk hi to lo transistion

	movf PORTA,W      ; get parity bit
	xorwf PAR,W       ; XOR with parity counter
	andlw 1           ; extract bit 0 of parity
	movwf PAR         ; and store it

	call HIGHLOW      ; get stop bit

	movf BYTE,W       ; is first byte $E0 (1st part of 2-byte set)?
	xorlw $E0
	btfsc STATUS,2
	call RECEIVE2     ; yes, so get second byte

	movf BYTE,W       ; is first byte $E1 (1st part of 2-byte set)?
	xorlw $E1
	btfss STATUS,2
	goto RX2A
	call RECEIVE2     ; yes, so get second byte
	goto RX4

RX2A:
	movf BYTE,W       ; is first byte $F0 (1st part of 2-byte set)?
	xorlw $F0
	btfsc STATUS,2
	call RECEIVE2     ; yes, so get second byte

RX4:
	return

; ************** get high to low transition ********

HIGHLOW:
	btfss PORTA,1     ; loop until CLK high
	goto HIGHLOW

HL2:
	btfsc PORTA,1     ; loop until CLK low
	goto HL2
	return

; ********* RECEIVE 2nd KEYBOARD BYTE (if 1st byte = E0, F0, E1) ******

RECEIVE2:
	movf BYTE,W       ; copy BYTE & PAR into BYTE2 & PAR2
	movwf BYTE2
	movf PAR,W
	movwf PAR2
	clrf PAR          ; clear parity record

	call HIGHLOW      ; get start bit

	clrf BYTE
	movlw 8           ; number of bits
	movwf LOOP

RECDATA2:
	rrf BYTE,F        ; rotate byte right
	call HIGHLOW      ; wait for hi to lo transistion

RX22:
	btfsc PORTA,0     ; is data low?
	goto RECSET2      ; no, it's high
	bcf BYTE,7        ; yes; it's high so clear bit 7 of BYTE
	goto RECNEXT2     ; and ignore parity counter
      
RECSET2:
	bsf BYTE,7        ; set bit 7 of byte
    incf PAR,F        ; inc parity counter

RECNEXT2:
	decfsz LOOP,F
	goto RECDATA2     ; loop until 8 bits have been recd

	call HIGHLOW      ; wait for clk hi to lo transistion
	movf PORTA,W      ; get parity bit
	xorwf PAR,W       ; XOR with parity counter
	andlw 1           ; extract bit 0 of parity
	movwf PAR         ; and store it
	return            ; end of 2nd byte key get routine


; tell the linker about our argument and local variable size

FNSIZE _receive,5,0

END
